<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Typed extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "typed";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[typed]first word|second word|3rd word[/typed]\n[typed speed=\"10\"]first word|second word|3rd word[/typed]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "speed",
			"hint"		=> "in miliseconds, default: 100",			
		),
		array(
			"name"		=> "cursor",
			"hint"		=> "any char, default: |",			
		),
		array(
			"name"		=> "loop",
			"hint"		=> "yes|no, default: yes",			
		),
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color",			
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),		
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {
		$this->loadTemplate();

		$vars	= $data["vars"];
		$css	= array();
		$style	= array();
		$attr	= array();

		$info = array(
			"cursor"	=> "|",
			"loop"		=> "true",
			"speed"		=> "100",
			"class"		=> "",			
			"css"		=> $vars["class"],
			"content"	=> $vars["content"]
		);

		if ($vars["loop"]) {
			$info["loop"] = $vars["loop"] == "yes" ? "true" : "false";
		}

		if ($vars["cursor"]) {
			$info["cursor"] = $vars["cursor"];
		}

		if ($vars["speed"]) {
			$info["speed"] = $vars["speed"];
		}		
		
		if ($vars["color"]) {
			$style[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}

		$info["style"] = implode(" " , $style);

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				$info
			),
			"before"	=> "",
			"after"		=> "",
		);
	
	
	}
	
	
}